#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex14-More functions in dplyr package
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

library(MASS)
newsurvey <- na.omit(survey)

#1.  Install the dplyr package and import it.
install.packages('dplyr')
library(dplyr)

#2.  Arrange all male left handers according to descending order of their heights.
newsurvey %>%
  filter(Sex=="Male"&W.Hnd=="Left")%>%
  arrange(desc(Height))

#3.  Introduce a new column hand_span which contains the value as difference between the span of writing hand and non-writing hand.
newsurvey%>%
  dplyr::select(Sex,Wr.Hnd,NW.Hnd)%>%
  mutate(Hnd_span=Wr.Hnd-NW.Hnd)


#4.  Display the average writing span male and female of left handers.
newsurvey%>%
  filter(W.Hnd=="Left")%>%
  group_by(Sex)%>%
  summarize(Avg_Write_Span=mean(Wr.Hnd))


#5.  Find the maximum pulse rate of male left and right handers.
newsurvey %>%
  filter(Sex=="Male")%>%
  group_by(W.Hnd) %>%
  summarize(max_pulserate=max(Pulse))